<?php

define('APP_NAME', 'tictic');
define('API_BASE_URL', 'https://domain.com/mobileapp_api/');
define('API_KEY', '156c4675-9608-4591-b2ec-xxxxxxx');
define('THEME_COLOR', '#036d53');
define('APP_URL', 'https://www.google.com/');
define('BASE_URL', getBaseUrl());


$imagebaseurl= API_BASE_URL;
$baseurl = API_BASE_URL."api/"; 


function curl_request($data,$url)
{
    $headers = [
        "Accept: application/json",
        "Content-Type: application/json",
        "api-key: ".API_KEY." "
    ];
    $data = $data;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $return = curl_exec($ch);
    $json_data = json_decode($return, true);
    $curl_error = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);   
    return $json_data;
}

function curl_request_debug($data,$url)
{
    $headers = [
        "Accept: application/json",
        "Content-Type: application/json",
        "api-key: ".API_KEY." "
    ];
    $data = $data;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $return = curl_exec($ch);
    $json_data = json_decode($return, true);
    $curl_error = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);   
    return $return;
}

function checkImageUrl($url)
{
    // Check if $url is empty
    if (empty($url)) {
        return "assets/img/noProfile.png";
    }

    $aws = strpos($url, 'amazonaws') !== false;
    $cdn = strpos($url, 'cdn') !== false;
    $cloudfront = strpos($url, 'cloudfront') !== false;
    $http = strpos($url, 'http') !== false;

    if ($aws || $cdn || $cloudfront || $http) 
    {
        return $url;
    } 
    else 
    {
        return imagebaseurl . "/" . $url;
    }
}


function getBaseUrl() 
{
    // Get the current full URL dynamically
    $inputUrl = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

    // Parse the URL to extract the path
    $parsedUrl = parse_url($inputUrl);
    
    // Trim leading/trailing slashes and explode into an array
    $pathParts = explode("/", trim($parsedUrl['path'], "/"));

    // Remove the last two segments (e.g., "video" and "ADEWE1ADGADSF1ADFADSF2")
    array_pop($pathParts); // Removes last segment
    array_pop($pathParts); // Removes second last segment

    // Reconstruct the URL dynamically
    $baseUrl = $parsedUrl['scheme'] . "://" . $parsedUrl['host'] . "/" . implode("/", $pathParts) . "/";

    return $baseUrl;
}



?>